<?php

namespace Database\Factories;

use Exception;
use App\Models\User;
use App\Models\Friend;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Friend>
 */
class FriendFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        if (User::all()->count() <= 1) {
            throw new Exception('Not enough users to make friends.');
        }
        $user1 = User::inRandomOrder()->first();
        $user2 = User::inRandomOrder()->first();

        $loops = 0;
        while (($user1 == $user2) || Friend::CheckInListExists($user1->id, $user2->id)) {
            $user1 = User::inRandomOrder()->first();
            $user2 = User::inRandomOrder()->first();
            $loops++;
            if ($loops > 1000) {
                throw new Exception('Failed to make friends.');
            }
        }

        $isSeen = fake()->boolean();
        $isAccepted = $isSeen && fake()->boolean();

        return [
            'from_user_id' => $user1->id,
            'to_user_id' => $user2->id,
            'is_seen' => $isSeen,
            'is_accepted' => $isAccepted,
        ];
    }
}
