<?php

namespace App\Repositories\General;

use Exception;
use Throwable;
use App\Models\Setting;
use App\Enums\SettingKey;
use App\Enums\SettingType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SettingRepository
{
    /**
     * Get Value by Name
     */
    public static function getValueByName(SettingKey $name, $userId)
    {
        $value = null;
        $setting = SettingRepository::getModelByName($name);
        if ($setting) {
            $value = match ($setting->type) {
                SettingType::NUMBER => (int) $setting->users()->find($userId)->pivot->value,
                SettingType::BOOLEAN => (bool) $setting->users()->find($userId)->pivot->value,
                default => $setting->users()->find($userId)->pivot->value,
            };
        }

        return $value;
    }

    /**
     * Get Setting by Name
     */
    public static function getModelByName(SettingKey $name): Setting
    {
        return Setting::where('name', $name)->first();
    }

    public function getAll()
    {
        $settings = Setting::all();
        $selectedSettings = auth()->user()->settings;

        foreach ($settings as $setting) {
            $setting->value = $selectedSettings->find($setting->id)?->pivot?->value ?? '';
        }

        return compact('settings');
    }

    public function save(Request $request)
    {
        try {
            DB::beginTransaction();

            $loginUser = auth()->user();

            $settings = Setting::all();

            $data = [];
            foreach ($settings as $setting) {
                $data[$setting->id] = ['value' => $request->{$setting->name->value}];
            }
            $loginUser->settings()->sync($data);

            DB::commit();
        } catch (Throwable $e) {
            DB::rollBack();

            Log::error(__CLASS__ . '::' . __FUNCTION__ . '[line: ' . __LINE__ . ']Message: ' . $e->getMessage());

            throw new Exception('Setting saved failed.');
        }
    }
}
