<?php

namespace App\Repositories\General;

use App\Models\Announcement;

class AnnouncementRepository
{
    public function getAll()
    {
        $announcements = Announcement::with([
            'user',
            'image',
        ])
            ->withTrashed()
            ->filter(request([
                'search',
            ]))
            ->latest('created_at')
            ->paginate(config('pagination.general'))
            ->withQueryString();

        return compact('announcements');
    }

    public function show($id)
    {
        $announcement = Announcement::with([
            'user',
            'image',
        ])
            ->withTrashed()
            ->find($id);

        return compact('announcement');
    }
}
