<?php

namespace App\Http\Requests\General;

use App\Models\Conversation;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ConversationGroupSaveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if ($this->input('id')) {
            return Conversation::owned()->find($this->input('id'))?->exists();
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $participants = [];
        if ($this->input('id')) {
            $conversation = Conversation::owned()->findOrFail($this->input('id'));
            $participants = $conversation->participants()->pluck('id')->toArray();
        }

        return [
            'id' => ['nullable', 'exists:conversations,id,deleted_at,NULL'],
            'name' => ['required', 'string', 'max:120'],
            'user_ids' => ['required', 'array', 'min:1'],
            'user_ids.*' => ['required', 'distinct', 'exists:users,id,deleted_at,NULL', Rule::notIn($participants)],
        ];
    }
}
