<?php

namespace App\Http\Controllers\Api\General;

use App\Http\Controllers\Api\GeneralController;
use App\Repositories\General\EventRepository;

class EventController extends GeneralController
{
    protected $eventRepository;

    public function __construct(EventRepository $eventRepository)
    {
        parent::__construct();
        $this->eventRepository = $eventRepository;
    }

    public function index()
    {
        $data = $this->eventRepository->getAll();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->eventRepository->show($id);

        return response()->json($data);
    }
}
