<?php

namespace App\Http\Controllers\Api\General;

use App\Models\User;
use App\Http\Controllers\Api\GeneralController;
use App\Repositories\General\ConversationRepository;
use App\Http\Requests\General\ConversationGroupSaveRequest;
use App\Http\Requests\General\ConversationMessageSaveRequest;
use App\Http\Requests\General\ConversationGroupMessageSaveRequest;

class ConversationController extends GeneralController
{
    protected $conversationRepository;

    public function __construct(ConversationRepository $conversationRepository)
    {
        parent::__construct();
        $this->conversationRepository = $conversationRepository;
    }

    public function index()
    {
        $data = $this->conversationRepository->getAll();

        return response()->json($data);
    }

    public function show(User $user)
    {
        $data = $this->conversationRepository->show($user);

        return response()->json($data);
    }

    public function save(ConversationMessageSaveRequest $request)
    {
        $this->conversationRepository->save($request);

        return response()->noContent();
    }

    public function seen(User $user, $messageId)
    {
        $this->conversationRepository->seen($user, $messageId);

        return response()->noContent();
    }

    public function deleteMessage(User $user, $messageId)
    {
        $this->conversationRepository->deleteMessage($user, $messageId);

        return response()->noContent();
    }

    public function saveGroup(ConversationGroupSaveRequest $request)
    {
        $this->conversationRepository->saveGroup($request);

        return response()->noContent();
    }

    public function showGroup($conversationId)
    {
        $data = $this->conversationRepository->showGroup($conversationId);

        return response()->json($data);
    }

    public function saveGroupMessage(ConversationGroupMessageSaveRequest $request, $conversationId)
    {
        $this->conversationRepository->saveGroupMessage($request, $conversationId);

        return response()->noContent();
    }

    public function seenGroup($conversationId, $messageId)
    {
        $this->conversationRepository->seenGroup($conversationId, $messageId);

        return response()->noContent();
    }

    public function leaveGroup($conversationId)
    {
        $this->conversationRepository->leaveGroup($conversationId);

        return response()->noContent();
    }

    public function deleteGroupMessage($conversationId, $messageId)
    {
        $this->conversationRepository->deleteGroupMessage($conversationId, $messageId);

        return response()->noContent();
    }

    public function deleteConversation($conversationId)
    {
        $this->conversationRepository->deleteConversation($conversationId);

        return response()->noContent();
    }
}
